/* Copyright (C) 2016-2018 RealVNC Ltd.  All Rights Reserved.
 */

/* This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#include "BaseDecoderSupport.h"

BaseDecoderSupport::BaseDecoderSupport(
        const VNCCommonDecoderSupportingAPI& decoderSupportingApi,
        VNCCommonDecoderFrameworkContext decoderFrameworkContext,
        vnccommon::LogHandler& logHandler)

    :   mSupportingApi(decoderSupportingApi),
        mFrameworkContext(decoderFrameworkContext),
        mLogHandler(logHandler)
{
}

vnccommon::LogHandler& BaseDecoderSupport::log()
{
    return mLogHandler;
}

void* BaseDecoderSupport::supportingApiAlloc(
        const size_t size)
{
    return mSupportingApi.vncCommonDecoderSupportingAPIAlloc(
            mFrameworkContext,
            size);
}

char* BaseDecoderSupport::supportingApiAllocString(
        const char *const str)
{
    return mSupportingApi.vncCommonDecoderSupportingAPIAllocString(
            mFrameworkContext,
            str);
}

void BaseDecoderSupport::supportingApiFree(
        void *const buffer)
{
    mSupportingApi.vncCommonDecoderSupportingAPIFree(
            mFrameworkContext,
            buffer);
}

void BaseDecoderSupport::supportingApiFreeString(
        char *const str)
{
    mSupportingApi.vncCommonDecoderSupportingAPIFreeString(
            mFrameworkContext,
            str);
}

void BaseDecoderSupport::supportingApiStreamRecyclePayload(
        const StreamID streamId,
        VNCCommonDecoderStreamPayload *const payload)
{
    mSupportingApi.vncCommonDecoderSupportingAPIStreamRecyclePayload(
            mFrameworkContext,
            streamId.toInteger(),
            payload);
}

void BaseDecoderSupport::supportingApiStreamRequestFrameRateLimit(
        const StreamID streamId,
        const vnc_uint32_t framerate)
{
    mSupportingApi.vncCommonDecoderSupportingAPIStreamRequestFrameRateLimit(
            mFrameworkContext,
            streamId.toInteger(),
            framerate);
}

void BaseDecoderSupport::supportingApiStreamRequestIDRFrame(
        const StreamID streamId)
{
    mSupportingApi.vncCommonDecoderSupportingAPIStreamRequestIDRFrame(
            mFrameworkContext,
            streamId.toInteger());
}

void BaseDecoderSupport::supportingApiStreamRequestReset(
        const StreamID streamId)
{
    return mSupportingApi.vncCommonDecoderSupportingAPIStreamRequestReset(
            mFrameworkContext,
            streamId.toInteger());
}

VNCCommonDecoderError BaseDecoderSupport::supportingApiLocalFeatureCheck(
        const std::vector<unsigned int>& featureIds,
        std::vector<int>& out_Results)
{
    vnccommon::LogHandler::Tagged log
            = mLogHandler.tag("BaseDecoderSupport::supportingApiLocalFeatureCheck");

    if(featureIds.size() == 0)
    {
        log.error("No features to check.");
        return VNCCommonDecoderErrorInvalidArgument;
    }

    if(out_Results.size() < featureIds.size())
    {
        log.error("Checking %lu features, but out_Results is too short (%lu).",
                static_cast<long unsigned>(featureIds.size()),
                static_cast<long unsigned>(out_Results.size()));
        return VNCCommonDecoderErrorInvalidArgument;
    }

    return mSupportingApi.vncCommonDecoderSupportingAPILocalFeatureCheck(
            mFrameworkContext,
            &(featureIds[0]),
            featureIds.size(),
            &(out_Results[0]));
}

void BaseDecoderSupport::supportingApiStreamError(
        const StreamID streamId,
        const VNCCommonDecoderError error)
{
    mSupportingApi.vncCommonDecoderSupportingAPIStreamError(
            mFrameworkContext,
            streamId.toInteger(),
            error);
}

void BaseDecoderSupport::supportingApiError(
        const VNCCommonDecoderError error)
{
    mSupportingApi.vncCommonDecoderSupportingAPIError(
            mFrameworkContext,
            error);
}

VNCCommonDecoderError BaseDecoderSupport::supportingApiSetFrameworkUserProperty(
        const vnc_int32_t propertyKey,
        const VNCCommonDecoderDataType propertyType,
        void *const propertyValue)
{
    return mSupportingApi.vncCommonDecoderSupportingAPISetFrameworkUserProperty(
            mFrameworkContext,
            propertyKey,
            propertyType,
            propertyValue);
}

void BaseDecoderSupport::supportingApiStreamResolutionUpdated(
        const StreamID streamId,
        const vnc_uint16_t width,
        const vnc_uint16_t height)
{
    mSupportingApi.vncCommonDecoderSupportingAPIStreamResolutionUpdated(
            mFrameworkContext,
            streamId.toInteger(),
            width,
            height);
}

void BaseDecoderSupport::supportingApiStreamCreateCompleted(
        const StreamID streamId)
{
    mSupportingApi.vncCommonDecoderSupportingAPIStreamCreateCompleted(
            mFrameworkContext,
            streamId.toInteger());
}

void BaseDecoderSupport::supportingApiStreamStartCompleted(
        const StreamID streamId)
{
    mSupportingApi.vncCommonDecoderSupportingAPIStreamStartCompleted(
            mFrameworkContext,
            streamId.toInteger());
}

void BaseDecoderSupport::supportingApiStreamStopCompleted(
        const StreamID streamId)
{
    mSupportingApi.vncCommonDecoderSupportingAPIStreamStopCompleted(
            mFrameworkContext,
            streamId.toInteger());
}

void BaseDecoderSupport::supportingApiStreamDestroyCompleted(
        const StreamID streamId)
{
    mSupportingApi.vncCommonDecoderSupportingAPIStreamDestroyCompleted(
            mFrameworkContext,
            streamId.toInteger());
}

